unit DiskInfoPanelImpl1;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, ActiveX, Classes, Controls, Graphics, Menus, Forms, StdCtrls,
  ComServ, StdVCL, AXCtrls, DiskInfoPanelXControl1_TLB, DiskInfo, ExtCtrls;

type
  TDiskInfoPanelX = class(TActiveXControl, IDiskInfoPanelX)
  private
    { Private declarations }
    FDelphiControl: TDiskInfoPanel;
    FEvents: IDiskInfoPanelXEvents;
  protected
    { Protected declarations }
    procedure DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage); override;
    procedure EventSinkChanged(const EventSink: IUnknown); override;
    procedure InitializeControl; override;
    function DrawTextBiDiModeFlagsReadingOnly: Integer; safecall;
    function Get_AlignDisabled: WordBool; safecall;
    function Get_DoubleBuffered: WordBool; safecall;
    function Get_DriveLetter: Smallint; safecall;
    function Get_Enabled: WordBool; safecall;
    function Get_ParentBackground: WordBool; safecall;
    function Get_Visible: WordBool; safecall;
    function Get_VisibleDockClientCount: Integer; safecall;
    function IsRightToLeft: WordBool; safecall;
    function UseRightToLeftReading: WordBool; safecall;
    function UseRightToLeftScrollBar: WordBool; safecall;
    procedure AboutBox; safecall;
    procedure InitiateAction; safecall;
    procedure Set_DoubleBuffered(Value: WordBool); safecall;
    procedure Set_DriveLetter(Value: Smallint); safecall;
    procedure Set_Enabled(Value: WordBool); safecall;
    procedure Set_ParentBackground(Value: WordBool); safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    procedure SetSubComponent(IsSubComponent: WordBool); safecall;
  end;

implementation

uses ComObj, About1;

{ TDiskInfoPanelX }

procedure TDiskInfoPanelX.DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage);
begin
  {TODO: Define property pages here.  Property pages are defined by calling
    DefinePropertyPage with the class id of the page.  For example,
      DefinePropertyPage(Class_DiskInfoPanelXPage); }
end;

procedure TDiskInfoPanelX.EventSinkChanged(const EventSink: IUnknown);
begin
  FEvents := EventSink as IDiskInfoPanelXEvents;
end;

procedure TDiskInfoPanelX.InitializeControl;
begin
  FDelphiControl := Control as TDiskInfoPanel;
end;

function TDiskInfoPanelX.DrawTextBiDiModeFlagsReadingOnly: Integer;
begin
  Result := FDelphiControl.DrawTextBiDiModeFlagsReadingOnly;
end;

function TDiskInfoPanelX.Get_AlignDisabled: WordBool;
begin
  Result := FDelphiControl.AlignDisabled;
end;

function TDiskInfoPanelX.Get_DoubleBuffered: WordBool;
begin
  Result := FDelphiControl.DoubleBuffered;
end;

function TDiskInfoPanelX.Get_DriveLetter: Smallint;
begin
  Result := Smallint(FDelphiControl.DriveLetter);
end;

function TDiskInfoPanelX.Get_Enabled: WordBool;
begin
  Result := FDelphiControl.Enabled;
end;

function TDiskInfoPanelX.Get_ParentBackground: WordBool;
begin
  Result := FDelphiControl.ParentBackground;
end;

function TDiskInfoPanelX.Get_Visible: WordBool;
begin
  Result := FDelphiControl.Visible;
end;

function TDiskInfoPanelX.Get_VisibleDockClientCount: Integer;
begin
  Result := FDelphiControl.VisibleDockClientCount;
end;

function TDiskInfoPanelX.IsRightToLeft: WordBool;
begin
  Result := FDelphiControl.IsRightToLeft;
end;

function TDiskInfoPanelX.UseRightToLeftReading: WordBool;
begin
  Result := FDelphiControl.UseRightToLeftReading;
end;

function TDiskInfoPanelX.UseRightToLeftScrollBar: WordBool;
begin
  Result := FDelphiControl.UseRightToLeftScrollBar;
end;

procedure TDiskInfoPanelX.AboutBox;
begin
  ShowDiskInfoPanelXAbout;
end;

procedure TDiskInfoPanelX.InitiateAction;
begin
  FDelphiControl.InitiateAction;
end;

procedure TDiskInfoPanelX.Set_DoubleBuffered(Value: WordBool);
begin
  FDelphiControl.DoubleBuffered := Value;
end;

procedure TDiskInfoPanelX.Set_DriveLetter(Value: Smallint);
begin
  FDelphiControl.DriveLetter := Char(Value);
end;

procedure TDiskInfoPanelX.Set_Enabled(Value: WordBool);
begin
  FDelphiControl.Enabled := Value;
end;

procedure TDiskInfoPanelX.Set_ParentBackground(Value: WordBool);
begin
  FDelphiControl.ParentBackground := Value;
end;

procedure TDiskInfoPanelX.Set_Visible(Value: WordBool);
begin
  FDelphiControl.Visible := Value;
end;

procedure TDiskInfoPanelX.SetSubComponent(IsSubComponent: WordBool);
begin
  FDelphiControl.SetSubComponent(IsSubComponent);
end;

initialization
  TActiveXControlFactory.Create(
    ComServer,
    TDiskInfoPanelX,
    TDiskInfoPanel,
    Class_DiskInfoPanelX,
    1,
    '',
    OLEMISC_SIMPLEFRAME or OLEMISC_ACTSLIKELABEL,
    tmApartment);
end.
